//------------------------------------------------------------------------------
// File: client_tasksystem.cs
// This file is used for initializing any task related systems and tasks on the
// client
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Functions--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Registers the task listener for messages
////////////////////////////////////////////////////////////////////////////////
function tsStartTaskListener()
{
   if (isObject(TaskListener) == false)
   {
      return;
   }
   
   TaskListener.startListen($MSG_TASKACTIVE);
   TaskListener.startListen($MSG_TASKDLG);
}

////////////////////////////////////////////////////////////////////////////////
//! Unregisters the task listener with messages
////////////////////////////////////////////////////////////////////////////////
function tsStopTaskListener()
{
   if (isObject(TaskListener) == false)
   {
      return;
   }
   
   // Clear task listener message queue
   TaskListener.clearMessageQueue();
   
   TaskListener.stopListen($MSG_TASKDLG);
   TaskListener.stopListen($MSG_TASKACTIVE);
}

function slgBuildClientTutorialTaskSystem()
{
   // Build the task manager
   slgBuildTaskManager(false);
   
   // Register for messages to listen for
   tsStartTaskListener();
   
   // Ready for initial tasks
   commandToServer('StartTutorialTasks', ServerConnection);
}

function slgBuildClientGameTaskSystem()
{
   // Build the task manager
   slgBuildTaskManager(false);
   
   // Register for messages to listen for
   tsStartTaskListener();
   
   // Ready for initial tasks
   commandToServer('StartGameTasks', ServerConnection);
}

function slgBuildClientSandboxTaskSystem()
{
   // Build the task manager
   slgBuildTaskManager(false);
   
   // Register for messages to listen for
   tsStartTaskListener();
   
   // Ready for initial tasks
   commandToServer('StartSandboxTasks', ServerConnection);
}

function slgDestroyClientTaskSystem()
{
   // Stop listening
   tsStopTaskListener();
   
   // Shutdown task manager
   slgShutdownTaskManager();
}
//------------------------------------------------------------------------------

// End client_tasksystem.cs